package co.carmentang.bonvoyage;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;

import java.util.HashMap;


public class EditAlbum extends Activity {

        EditText albumName;
        DBController controller = new DBController(this);
        @Override
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            setContentView(R.layout.activity_edit_album);
            albumName = (EditText) findViewById(R.id.albumName);
            Intent objIntent = getIntent();
            String animalId = objIntent.getStringExtra("albumId");
            Log.d("Reading: ", "Reading all contacts..");
            HashMap<String, String> animalList = controller.getAnimalInfo(animalId);
            Log.d("albumName",animalList.get("albumName"));
            if(animalList.size()!=0) {
                albumName.setText(animalList.get("albumName"));
            }
        }
        public void editAlbum(View view) {
            HashMap<String, String> queryValues =  new  HashMap<String, String>();
            albumName = (EditText) findViewById(R.id.albumName);
            Intent objIntent = getIntent();
            String albumId = objIntent.getStringExtra("albumId");
            queryValues.put("albumId", albumId);
            queryValues.put("albumName", albumName.getText().toString());

            controller.updateAlbumName(queryValues);
            this.callHomeActivity(view);

        }
        public void removeAlbum(View view) {
            Intent objIntent = getIntent();
            String albumId = objIntent.getStringExtra("albumId");
            controller.deleteAlbumName(albumId);
            this.callHomeActivity(view);

        }
        public void callHomeActivity(View view) {
            Intent objIntent = new Intent(getApplicationContext(), AlbumActivity.class);
            startActivity(objIntent);
        }




    // FORM PATTERN
    // this screen should have a vertical grid layout that has rows to align the content
    // there will be form input for
    // "Title of New Album"
    // and clicking on the form field will display the keyboard for input
    // and then a button under the form field for input
    // this will create data that will be stored on the phone because it needs to be used in
    // other screens

    // this screen will also make use of the SQLite database to store the title of album values


    //Intent for passing intent extra to another class *****
    //OnClick listener for ExplicitIntent button
    // public void onClickExplicitIntent(View V)
    //{
        // Create The Explicit Intent and Start The Activity
        // here you force explicitly to start SecondActivity.
    //    Intent intentExplicit =new Intent(this,AlbumActivity.class);
    //    intentExplicit.putExtra("First Value", "This First Value for ActivityTwo"); // optional
    //    intentExplicit.putExtra("Second Value", "This Second Value for ActivityTwo"); //optional
    //    startActivity(intentExplicit);// Activity is started using explicit intent.
    //}



    // START UP METHODS
    // this and the NewAlbumForm are the only places where I think
    // onPause() and onResume() might be useful. If someone is typing in something, I want their
    // text to still be there if they had to answer a call for example.


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.new_album_form, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
